package gov.va.med.mhv.usermgmt.data.repository;


import java.util.List;

import gov.va.med.mhv.usermgmt.data.model.UserPasswordHistory;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface UserPasswordHistoryRepository extends JpaRepository<UserPasswordHistory, Long> {
	@Modifying
	@Transactional
	@Query("delete from UserPasswordHistory u where u.userProfileId= :userProfileId")
	void deleteByUserProfileId(@Param("userProfileId") Long userProfileId);
	
	
	 @Query("select a from UserPasswordHistory a where a.userProfileId =:userProfileId  order by a.updatedTime desc")	
	 List<UserPasswordHistory>  getLastThreePasswords(@Param("userProfileId") Long userProfileId, Pageable page);
	 
	 
	 @Query("select a from UserPasswordHistory a where a.userProfileId =:userProfileId  order by a.updatedTime desc")	
	 List<UserPasswordHistory>  getPreviousPasswords(@Param("userProfileId") Long userProfileId);

}